c sha.f
c Design of analematic sundials.
c Navrh analematickych slunecnich hodin.
c Miroslav Broz (miroslav.broz@email.cz), Jan 2nd 2005

      program SLUNECNI_HODINY_ANALEMATICKE

      implicit none

      real*8 pi,deg,rad
      parameter(pi=3.1415926535d0,deg=pi/180.d0,rad=180.d0/pi)

      real*8 a,phi,dt,b,MF,R,t,x,y,tmp,x0,y0,d,l,l0,dl,jd0,dd
      integer i,j,iu,iug,iud,iue,t_SEC,ndate,nhour,t_znameni,il,ir
      real*8 ra,delta,ah,ht,becl,ha,de,year,month,day,jd,eps,lambda
      real*8 w,h,x1,x2,y1,y2,lambda15,t_corr,hour,minute,second
      real*8 yn(1:14),deltan(1:12),lecln(1:12),dayn(1:12)

      character*255 phistr,dtstr,destr,ddstr,lambdastr,str,str0

      character*80 empty_file_string
      character*5 romannumeral(0:24)
      character*3 znamenistr(1:12)
      character*3 monthstr(1:12)

c  functions
      real*8 reads3,jdate,eps_earth,sgn
      integer length

      data empty_file_string /'("?",/)'/

      data romannumeral /
     :  '0',
     :  'I',
     :  'II',
     :  'III',
     :  'IV',
     :  'V',
     :  'VI',
     :  'VII',
     :  'VIII',
     :  'IX',
     :  'X',
     :  'XI',
     :  'XII',
     :  'XIII',
     :  'XIV',
     :  'XV',
     :  'XVI',
     :  'XVII',
     :  'XVIII',
     :  'XIX',
     :  'XX',
     :  'XXI',
     :  'XXII',
     :  'XXIII',
     :  'XXIV'
     :  /

      data znamenistr /
     :  'Aqr',
     :  'Psc',
     :  'Ari',
     :  'Tau',
     :  'Gem',
     :  'Cnc',
     :  'Leo',
     :  'Vir',
     :  'Lib',
     :  'Sco',
     :  'Sgr',
     :  'Cap'
     :  /

      data monthstr /
     :  'Jan',
     :  'Feb',
     :  'Mar',
     :  'Apr',
     :  'May',
     :  'Jun',
     :  'Jul',
     :  'Aug',
     :  'Sep',
     :  'Oct',
     :  'Nov',
     :  'Dec'
     :  /

c=======================================================================
c
c  read standard input
c  cteni standardniho vstupu
c
5     continue
        write(*,21)
21      format('# zemepisna sirka stanoviste phi [DD:MM:SS]:')
        read(*,10,err=15,end=15) phistr
10      format(a)
      if (phistr(1:1).eq.'#') goto 5

      write(*,22)
22    format('# velka poloosa elipsy a [cm]:')
      read(*,*,err=15,end=15) a

      write(*,23)
23    format('# casovy krok dt [HH:MM:SS]:')
      read(*,10,err=15,end=15) dtstr

      write(*,24)
24    format('# casovy krok pro body elipsy de [HH:MM:SS]:')
      read(*,10,err=15,end=15) destr

      write(*,25)
25    format('# sirka desky w [cm]:')
      read(*,*,err=15,end=15) w

      write(*,26)
26    format('# vyska gnomonu (postavy) [cm]:')
      read(*,*,err=15,end=15) h

      write(*,27)
27    format('# casovy krok datovych krivek dd [HH:MM:SS]:')
      read(*,10,err=15,end=15) ddstr

      write(*,31)
31    format('# pocet datovych krivek? [0|3|7]:')
      read(*,*,err=15,end=15) ndate

      write(*,28)
28    format('# zemepisna delka stanoviste lambda [DD:MM:SS]:')
      read(*,10,err=15,end=15) lambdastr

      write(*,29)
29    format('# korekce o delku? [0|1]:')
      read(*,*,err=15,end=15) t_SEC

      write(*,32)
32    format('# datova usecka pro zacatky mesicu [0], ',
     :  'stredni deklinace [1] ',
     :  'nebo vstupy slunce do znameni [2]:')
      read(*,*,err=15,end=15) t_znameni

      goto 20
15    continue
        write(*,*) 'Chyba pri cteni vstupnich parametru.'
        stop
20    continue

c=======================================================================

c  interpretation and check print of input parametres
c  interpretace a kontrolni tisk vstupnich parametru
      phi = reads3(phistr)
      dt = reads3(dtstr)*rad
      de = reads3(destr)*rad
      dd = reads3(ddstr)*rad/24.d0
      lambda = reads3(lambdastr)

      if (ndate.gt.100) ndate=100       ! max number of date curves/maximalni pocet datovych krivek
      if (ndate.lt.0) ndate=0
      if (ndate.eq.1) ndate=2

      write(*,30) phi*rad,a,2*a,dt,de,w,h,dd,ndate,lambda*rad,t_SEC,
     :  t_znameni
30    format('# phi = ',f10.6,' deg',/,
     :  '# a = ',f8.2,' cm, 2a = ',f8.2,' cm',/,
     :  '# dt = ',f10.6,' h',/,
     :  '# de = ',f10.6,' h',/,
     :  '# w = ',f8.2,' cm',/,
     :  '# h = ',f8.2,' cm',/,
     :  '# dd = ',f10.6,' h',/,
     :  '# ndate = ',i3,/,
     :  '# lambda = ',f10.6,' deg',/,
     :  '# t_SEC = ',i1,/,
     :  '# t_znameni = ',i1)

c  lambda a t_SEC se (zatim) nikde nepouzivaji!

c  obliquity of the Earth's orbit
c  sklon zemske osy
      eps=eps_earth(0.d0)
c
c  labels for Gnuplot
c  popisky pro Gnuplot
c
      iug=30
      open(unit=iug,file='popisky.plt',status='unknown')
      write(iug,90)
90    format('# popisky pro Gnuplot (PostScript)') 

c=======================================================================

c  round-off lambda to 15 deg
c  zaokrouhleni lambda na 15 deg
      lambda15 = int(lambda*rad/15.d0+0.5)*15.d0*deg
      t_corr = (lambda15-lambda)/pi*12.d0

c  output file with time-longitude correction
c  vystupni soubor s casovou korekci
      iu=20
      open(unit=iu,file='korekce.dat',status='unknown')
      write(iu,270)
270   format('# casova korekce na zemepisnou delku: minuty & sekundy')

      if (t_SEC.ne.1) then
        call hhms(abs(t_corr)+0.5d0/3600.d0,hour,minute,second)
        write(iu,280) int(sgn(t_corr)*minute), int(second)
280     format(i4,1x,i2)
        t_corr = 0.d0
      else
        write(iu,280) 0, 0
      endif

      close(iu)

c=======================================================================
c
c  basic parametres of the ellipse
c  zakladni parametry elipsy
c
      b = a*sin(phi)
      MF = a*cos(phi)

      write(*,40) b,2*b,MF
40    format('# parametry elipsy: ',
     :  'mala poloosa & vzdalenost ohniska od stredu',/,
     :  '# b = ',f8.2,' cm, 2b = ',f8.2,' cm',/,
     :  '# MF = ',f8.2,' cm')

c  the ellipse as an detailed data-file
c  elipsa jako podrobny datovy soubor
      open(unit=iu,file='elipsa.dat',status='unknown')

      write(iu,60) a,2*a,b,2*b,MF
60    format('# elipsa: hodinovy uhel +12 h [h] & x [cm] & y[cm]',/,
     :  '# a = ',f8.2,' cm, 2a = ',f8.2,' cm',/,
     :  '# b = ',f8.2,' cm, 2b = ',f8.2,' cm',/,
     :  '# MF = ',f8.2,' cm')

      t=0.d0
      do while (t<24.d0+de+1e-8)
        tmp=t/12.d0*pi
        x=a*sin(tmp)
        y=b*cos(tmp)

        write(iu,50) t,x,y

        t=t+de
      enddo

      close(iu)

c  setup dimensions of the dial in Gnuplot
c  nastaveni rozmeru ciselniku v Gnuplotu

      tmp=1.15
      x1=-a*tmp
      x2=a*tmp
      y1=-b*tmp
      y2=b*tmp

      open(unit=iu,file='ciselnik.plt',status='unknown')

      write(iu,260) x1,x2,y1,y2
260   format('# nastaveni rozsahu os x a y v Gnuplotu',
     :  ' = rozmer ciselniku [cm]',/,
     :  'x1 = ', f8.2,/,'x2 = ',f8.2,/
     :  'y1 = ', f8.2,/,'y2 = ',f8.2,/,
     :  'set xr [x1:x2]',/,'set yr [y1:y2]')

      close(iu)

c=======================================================================
c
c  hour marks
c  hodinove znacky
c
      open(unit=iu,file='hodin.dat',status='unknown')

      write(iu,220)
220   format('# hodinove znacky: hodina [h] & x [cm] & y[cm]')

c here, one can check the altitude of the Sun above the horizon
c in different seasons... (see Lambert circles at least)
c zde by evidentne chtelo kontrolovat vysku Slunce nad obzorem
c v ruznych rocnich obdobich... (zatim viz alespon Lambertovy kruznice)

      t=0.d0
      do while (t<24.d0)
c zde bylo predtim chybne + t_corr! Opraveno 25. 4. 2006
c here was errorneously + t_corr! Corrected...
        tmp=(t - t_corr - 12.d0)/12.d0*pi
        x=a*sin(tmp)
        y=b*cos(tmp)

        write(iu,50) t,x,y
50      format(f10.5,1x,f8.2,1x,f8.2)

c  Gnuplot labels (including HH:MM)
        call hhms(t + 0.5d0/3600.d0,hour,minute,second)
        write(str,*) int(hour)
        if (int(minute).eq.0) then
          write(iug,100) str(1:length(str)),x,y
100       format('set label " ',a,'" at ',f10.4,',',f10.4,' $0')
        else
          write(iug,290) str(1:length(str)),int(minute),x,y
290       format('set label " ',a,'^{',i2,'}" at ',f10.4,',',f10.4,
     :      ' $0')
        endif

        t=t+dt
      enddo

      close(iu)

c=======================================================================
c
c  date scale on the middle desk (3 different variants)
c  datova skala na stredove desce (3 ruzne varianty)
c

      year=2000.d0      ! for this year the positions of the Sun will be calculated/pro tento rok budou pocitany polohy slunce
      x=0.d0

      if (t_znameni.eq.0) then

c  a calculation of the declination for the months beginnings of the given year
c  vypocet deklinaci pro zacatky mesicu daneho roku

        day=1.d0

        do i=1,12
          dayn(i) = day
          month=1.d0*i
          jdate=jd(year,month,day)
          call sunah(jdate,lambda,phi,1,0,0,ah,ht,ra,deltan(i),ha,
     :      lecln(i),becl)
        enddo


      else if (t_znameni.eq.1) then

c  mean solar declination for the month beginnings
c  stredni deklinace pro zacatky mesicu

c  (prevzato z Sangwin, C., Budd, C.: Analemmatic sundials: How to build one
c  and how they work. <http://plus.maths.org/issue11/feature/sundials/>.)

        deltan(1)  = -23.13     ! tato cisla jsou podezrele "okrouhla"!
        deltan(2)  = -17.30
        deltan(3)  =  -8.00
        deltan(4)  =   4.25
        deltan(5)  =  15.00
        deltan(6)  =  22.00
        deltan(7)  =  23.00
        deltan(8)  =  18.00
        deltan(9)  =   8.50
        deltan(10) =  -2.90
        deltan(11) = -14.00
        deltan(12) = -21.70

        do i=1,12
          lecln(i) = 0.d0       ! I won't calculate eclitical longitudes/ekliptikalni delky pocitat nebudu...
          dayn(i) = 1
          deltan(i) = deltan(i)*deg
        enddo

      else

c  declinations for entries of the Sun into zodiac signs
c  deklinace pro vstupy slunce do znameni zviretniku

        dl = 30.d0*deg
        l0 = 300.d0*deg
        becl = 0.d0
        t = 0.d0

        l = l0
        do i=1,12
          call stredni_slunce_dah(l,becl,t,0.d0,phi,deltan(i),ah,ht)
          lecln(i) = l
          l = l + dl
          if (l.gt.360.d0*deg) l = l - 360.d0*deg
        enddo

c  approximate days of month (it would be better to take mean values)
c  priblizne dny v mesici (lepsi by bylo vzit prumerne)
        dayn(1)  = 20
        dayn(2)  = 19
        dayn(3)  = 20
        dayn(4)  = 19
        dayn(5)  = 20
        dayn(6)  = 21
        dayn(7)  = 22
        dayn(8)  = 23
        dayn(9)  = 22
        dayn(10) = 23
        dayn(11) = 22
        dayn(12) = 21

      endif

c  the calculation of the desk positions
c  vlastni vypocet poloh na desce
      open(unit=iu,file='datum.dat',status='unknown')

      write(iu,170)
170   format('# datova skala: ',
     :  'deklinace slunce delta [deg] & ',
     :  'x [cm] & y [cm] & ',
     :  'ekliptikalni delka l [deg] & ',
     :  'datum [YYYY MM DD]')

      do i=1,12
        month = i*1.d0

        y=a*cos(phi)*tan(deltan(i))

c  save positions for later use
c  uloz polohy pro pozdejsi pouziti
        yn(i)=y

        write(iu,70) deltan(i)*rad,x,y,lecln(i)*rad,
     :    int(year+.5d0),int(month+.5d0),int(dayn(i)+.5d0)
70      format(f10.4,1x,f8.2,1x,f8.2,1x,f9.3,2x,i4,1x,i2,1x,i2,1x)

c  labels for Gnuplot
c  znacky pro Gnuplot
        if (t_znameni.eq.2) then
          str=znamenistr(int(month+0.5d0))
        else
          str=romannumeral(int(month+0.5d0))
        endif
        if (i.le.6) then
          str0=' right'
        else
          str0=''
        endif
        write(iug,110) str(1:length(str)),x,y,str0
110     format('set label "   ',a,'   " at ',f10.4,',',f10.4,a,' $0')

      enddo
c
c  desk margins for date scale
c  okraje desky pro datovou skalu
c
      write(iu,120)
120   format('# zimni a letni slunovrat ',
     :  '(poloha gnomonu na okraji desky)')
      y=a*cos(phi)*tan(eps)
      d=2.d0*y
      write(iu,70)  eps*rad,x, y, 90.d0,2000, 6,21 
      write(iu,70) -eps*rad,x,-y,270.d0,2000,12,21
      yn(13)=-y
      yn(14)=y

      write(iu,160) d
160   format('# d = ',f8.2,' cm <- vysledna delka desky')

      close(iu)

c=======================================================================
c
c  a drawing of the desk
c  nakres desky
c
      iud=40
      iue=50
      open(unit=iud,file='deska.dat',status='unknown')
      open(unit=iue,file='deska_popis.plt',status='unknown')

      write(iud,185)
185   format('# souradnice vyznacnych bodu stredove desky: ',
     :  'x [cm] & y[cm]')

c  optional shift of the coordinate centre (it is easier to measure from margins)
c  eventualni posun stredu souradnic (snadneji se meri od okraje)
c      do i=1,14
c        yn(i)=yn(i)+yn(14)
c      enddo

c  circumference and the middle-line
c  obvod a stredova cara desky
      x=0.d0
      write(iud,180) x-w/2,yn(13),x+w/2,yn(13),x+w/2,yn(14),
     :  x-w/2,yn(14),x-w/2,yn(13)
180   format(5(f10.4,1x,f10.4,/),/)

      write(iud,190) x,yn(13),x,yn(14)

c  month labels at the desk left left-/righthanded
c  popisky mesicu na desce levo-/pravotocive
      il=1
c      il=1
      ir=-il

      do i=1,12
        if (i.le.6) then
          write(iud,190) x,yn(i),x+il*w/2,yn(i)
190       format(2(f10.4,1x,f10.4,/),/)
        else
          write(iud,190) x,yn(i),x+ir*w/2,yn(i)
        endif

c  line coordinates
c  kotovani car
        write(iue,200) yn(i),1.d0,yn(i),''
200     format('set label "',f8.2,'  " at graph ',f10.4,
     :    ', first ',f10.4,a)

c  numbers (or month abbreviations) in the middle of the rectangle
c  cislice (nebo nazvy mesicu) uprostred obdelniku
        if (t_znameni.lt.2) then
          str=romannumeral(i)
c          str=monthstr(i)
          if (i.le.6) then
            write(iue,210) str(1:length(str)),x+il*w/4,(yn(i)+yn(i+1))/2
210         format('set label "',a,'" at ',f10.4,',',f10.4,' center')
          else
            write(iue,210) str(1:length(str)),x+ir*w/4,(yn(i)+yn(i+1))/2
          endif
        else
          tmp=yn(13)
          yn(13)=yn(1)
          str=znamenistr(i)
          if ((i.le.5).or.(i.eq.12)) then
            write(iue,210) str(1:length(str)),x+il*w/4,(yn(i)+yn(i+1))/2
          else
            write(iue,210) str(1:length(str)),x+ir*w/4,(yn(i)+yn(i+1))/2
          endif
          yn(13)=tmp
        endif

      enddo

      write(iue,200) yn(13),0.,yn(13),' right'
      write(iue,200) yn(14),0.,yn(14),' right'

      close(iud)
      close(iue)

c=======================================================================
c
c  Lambert circles (only 3 yet, resp. 2, because 1 is straight line)
c  Lambertovy kruznice (zatim jenom 3, resp. 2, protoze 1 je primka)
c
      write(*,130)
130   format('# Lambertovy kruznice: ',
     :  'deklinace & polomer & poloha stredu x = 0')

      open(unit=iu,file='lambert.dat',status='unknown')

      write(iu,140)
140   format('# Lambertovy kruznice: x [cm] & y[cm]')

      do i=-1,1,2
        delta=i*eps
        R=MF/sin(2*delta)
        y=MF/tan(2*delta)

        write(*,80) delta*rad,R,y
80      format('# delta = ',f10.4,' deg, ',
     :    'R = ',f8.2,' cm, ',
     :    'y = ',f8.2,' cm')

c  vystup do datoveho souboru pro gnuplot
        write(iu,*)
        write(iu,*)
        write(iu,80) delta*rad,R,y
        t=0.d0
        y0=y
        x0=0.d0
        do while (t<24.d0)
          tmp=t/12.d0*pi
          x=x0+R*sin(tmp)
          y=y0+R*cos(tmp)

c  vypis jen pokud lezi uvnitr elipsy!
          if (((x/a)**2+(y/b)**2).lt.1.d0) then
            write(iu,150) x,y
150         format(f10.4,1x,f10.4)
          endif
        
          t=t+de
        enddo

      enddo

      close(iu)

c=======================================================================
c
c  date curves for given height (and position) of the gnomon (body)
c  datove krivky pro danou vysku (a polohu) gnomonu (postavy)
c
      open(unit=iu,file='datum_prumet.dat',status='unknown')

      write(iu,245) h
245   format('# datove krivky: ',
     :  'cas t [h] & ',
     :  'azimut slunce az [deg] & ',
     :  'vyska [deg] & ',
     :  'prumet konce stinu gnomonu x [cm] & y [cm]',/,
     :  '# h = ',f6.2,' cm <- vyska gnomonu (postavy)',/)

      dl = 180.d0*deg/(ndate-1)
      l0 = 90.d0*deg
      becl = 0.d0*deg
      nhour = int(1.d0/dd+0.5d0)

      do j = 1, ndate
        l = l0 + (j-1)*dl

c shifts of curves wrt. seasonal motion of the gnomon
c posuny krivek vzhledem k pohybu gnomonu po datove desce
        call stredni_slunce_dah(l,becl,t,0.d0,phi,delta,ah,ht)
        y=a*cos(phi)*tan(delta)

        write(iu,240) l*rad,delta*rad,y
240     format('# l = ',f6.2,' deg, ',
     :    'delta = ',f6.2,' deg, ',
     :    'y = ',f6.2,' cm')

        do i = 0, nhour-1
          t = i*dd*24.d0

c projection of gnomon's end to the horizontal plane
c (there is NO problem with shadowing by the dial plane, like in SHC)
c prumet konce gnomonu do vodorovne roviny
c (zde neni zadny problem se stinenim rovinou ciselniku jako v SHC)
          call stredni_slunce_dah(l,becl,t,0.d0,phi,delta,ah,ht)

          if (ht.gt.-1.d-8) then

            tmp = abs(h/tan(ht))
            x0 = tmp*sin(ah)
            y0 = y + tmp*cos(ah)

            write(iu,250) t,ah*rad,ht*rad,x0,y0
250         format(f7.4,1x,f8.3,1x,f7.3,1x,g12.4,1x,g12.4)

          endif

        enddo

        write(iu,*)
      enddo

      close(iu)

c=======================================================================

c  close Gnuplot labels file
c  zavreni souboru pro Gnuplot
      close (iug)
 
      stop
      end


c-----------------------------------------------------------------------
c
c  Calculate delta, A, h of the MEAN sun (for given ecliptic
c  coordinates l, b and observation site lambda, phi).
c  Vypocet delta, A, h STREDNIHO slunce (pro dane ekliptikalni
c  souradnice l, b a pozorovaci stanoviste lambda, phi).
c
      subroutine stredni_slunce_dah(l,b,t,lambda,phi,delta,a,h)

      implicit none
      real*8 l,b,t,lambda,phi,delta,a,h

      real*8 t0,x(3),x0(3),s0,ss,s,epsilon,alpha
      real*8 pi,degrad
      parameter(pi = 3.1415926535d0, degrad = pi/180.0d0)
c  functions
      real*8 nula2pi,eps_earth
                   
      x0(1) = -cos(l)*cos(b)
      x0(2) = -sin(l)*cos(b)
      x0(3) = -sin(b)
      t0 = 0.d0
      epsilon = eps_earth(t0)
      call rotat1(x0,x,epsilon)
      alpha = atan2(x(2),x(1))
      delta = asin(x(3))

c  hvezdny cas se nepocita z JD, ale odvozuje z delky <- toto BYLO CHYBNE!
c      s0 = l/pi*12.d0

c  if sidereal time is equal to right ascension, the motion of the mean Sun
c  along the ecliptic is uniform
c  je-li hvezdny cas roven rektascenzi, pak pohyb stredniho slunce
c  po ekliptice je rovnomerny!!!
      s0=alpha/pi*12.d0+12.d0
c  here, 1 h solar time corresponds to 15 degrees
c  zde 1 h slunecniho casu odpovida 15 stupnum!!!
      ss=s0+t
      s=ss+lambda/degrad/15.d0
      call rotat3(x,x0,s/12.d0*pi)
      call rotat2(x0,x,pi/2.d0-phi)
      a = nula2pi(-atan2(x(2),x(1)))
      h = asin(x(3))

      return
      end

