<?php

# sha.php
# WWW rozhrani pro navrh analematickych hodin (SHA).
# Miroslav Broz (miroslav.broz@email.cz)

$version_cz = "20. 3. 2022";
$admin = "miroslav.broz@email.cz";
$url = "http://astro.mff.cuni.cz/mira/sha/sha.php";
$cgi_file = "./sha.php";
$katalog = "http://astro.troja.mff.cuni.cz/mira/sh/sh.php";

$version_cz = preg_replace("/ /", "&nbsp;", $version_cz);

ob_start(); # switch output buffering on! (it improves performance greatly)

########################################################################

# pass variables (in case register_globals = Off in /etc/php/php.ini)

$QUERY_STRING = $_SERVER["QUERY_STRING"];

$submit		= $_GET["submit"];
$type		= $_GET["type"];
$lang		= $_GET["lang"];

$phi		= $_GET["phi"];
$a		= $_GET["a"];
$dt		= $_GET["dt"];
$de		= $_GET["de"];
$w		= $_GET["w"];
$h		= $_GET["h"];
$dd		= $_GET["dd"];
$ndate		= $_GET["ndate"];
$lambda		= $_GET["lambda"];
$t_SEC		= $_GET["t_SEC"];
$t_znameni	= $_GET["t_znameni"];

########################################################################

# log EVERYTHING

#error_reporting(E_ERROR); # error handling

$log_file = "./sha.log";
$id = fopen($log_file, "a");
if (!$id)
  err_msg("Chyba při otevírání log-souboru `$log_file'.");

$date = date("Y/m/d H:i:s");
if (sizeof($_POST) > 0) {
  $POST_VARS = " HTTP_POST_VARS";
  while (list($key, $val) = each($_POST))
     $POST_VARS = $POST_VARS . "\n  $key: $val";
} else
  $POST_VARS = "";
$out = "$date " . gethostbyaddr($_SERVER['REMOTE_ADDR']) . " " . $_SERVER['$REMOTE_ADDR'] ." $cgi_file?$QUERY_STRING$POST_VARS\n";
fwrite($id, $out);
fclose($id);

######################################################################

# decode message file

$msg_file = "./sha.msg";

function read_msg($lang) {
  global $msg_file, $__;

  $id = fopen($msg_file, "r");
  if (!$id)
    err_msg("Chyba při otevírání souboru `$msg_file'.");
  $msg = fread($id, filesize($msg_file));
  fclose($id);

  $l = explode("\n", $msg);
  $j = -1;
  for ($i = 0; $i < sizeof($l)-1; $i++) {
    if (strlen($l[$i]) == 0) {
# fallback language 0
      if ($j <= $lang)
        $__[$key] = $l[$i-$j];
      $j = -2;
    }
    if ($j == -1)
      $key = $l[$i];
    if ($j == $lang)
      $__[$key] = $l[$i];
# comment character
    if (substr($l[$i], 0, 1) != "#")
      $j++;
  }
}

if (!isset($lang))
  $lang = 0;
read_msg($lang);

######################################################################

# header/footer/menu

$header = <<<EOF
<!doctype html public "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
<meta http-equiv="Content-type" content="text/html; charset=utf-8">
<meta name="keywords" lang="cs" content="slunecni, sluneční, hodiny, číselník, návrh, analematické">
<meta name="keywords" lang="sk" content="slnecne, slnečné, hodiny, ciferník, návrh, analematické">
<meta name="keywords" lang="en" content="sundial, sundials, design, analemmatic">
<meta name="keywords" lang="de" content="sonnenuhr, sonnenuhren, analemmatische">
<meta name="keywords" lang="fr" content="cadran, cadrans, solaires, analemmatique">
<meta name="description" lang="cs" content="Sluneční hodiny - návrh číselníku">
<meta name="description" lang="sk" content="Slnečné hodiny - návrh ciferníka">
<meta name="description" lang="en" content="Sundials">
<meta name="description" lang="de" content="Sonnenuhren">
<meta name="description" lang="fr" content="Cadrans solaires">
<title>$__[0]</title>
</head>

<body bgcolor="#cccccc" text="#000000" link="#0000ee" vlink="#000088" alink="#000000">
<img src="sha.jpg" align="right" alt="$__[1]">
<h1>$__[0]</h1>

EOF;

$footer = <<<EOF

<p><hr>
<small>
&copy;
<a href="mailto:$admin">Miroslav Brož</a>
-
<a href="$url"><code>$url</code></a>;
$__[2] $version_cz
</small>
<hr>

</body>
</html>
EOF;

$menu = <<<EOF
[&nbsp;<a href="$cgi_file?lang=$lang">$__[3]</a>
| <a href="$cgi_file?type=help&lang=$lang">$__[5]</a>
| <a href="$cgi_file?type=download&lang=$lang">$__[4]</a>
| <a href="../shc/shc.php">SHC</a> ($__[7])
| <a href="http://www.astrohk.cz/slunecni_hodiny.html">$__[6]</a>
| <a href="$cgi_file?lang=0"><img src="cz.gif" border="0"></a>&nbsp;<a href="$cgi_file?lang=0">Česky</a>
| <a href="$cgi_file?lang=1"><img src="gb.gif" border="0"></a>&nbsp;<a href="$cgi_file?lang=1">English</a>&nbsp;]

<hr>
EOF;

########################################################################

if (!strcmp($submit, "$__[22]")) { sha(); }
else if (!strcmp($type, "download")) { download(); }
else if (!strcmp($type, "help")) { print_help(); }
else { print_form(); }

exit;

########################################################################

function err_msg($message) {
  global $header, $footer, $menu, $admin;

  echo <<<EOF
$header
$menu

<p><font color="red">$message</font>
<p>Kontaktujte prosím <a href="mailto:$admin">administrátora</a>.

$footer
EOF;
  exit;
}

########################################################################

function default_values() {

# form vars
  global $phi, $a, $dt, $de, $w, $h, $dd, $ndate, $lambda, $t_SEC, $t_znameni;

  if (!isset($phi))	$phi = "50:10";
  if (!isset($a))	$a = 250;
  if (!isset($dt))	$dt = "1:0:0";
  if (!isset($de))	$de = "0:1:0";
  if (!isset($w))	$w = 35;
  if (!isset($h))	$h = 180;
  if (!isset($dd))	$dd = "1:0:0";
  if (!isset($ndate))	$ndate = 7;
  if (!isset($lambda))	$lambda = "15:41";
  if (!isset($t_SEC))	$t_SEC = 0;
  if (!isset($t_znameni))	$t_znameni = 0;

# set reasonable limits
  $tmp = 1./60.;
  if (hmsh($dt) < $tmp)	$dt = $tmp;
  if (hmsh($de) < $tmp)	$de = $tmp;
  if (hmsh($dd) < $tmp)	$dd = $tmp;
}

########################################################################

function print_form() {
  global $header, $footer, $menu, $cgi_file, $katalog, $lang, $__;

# form vars
  global $phi, $a, $dt, $de, $w, $h, $dd, $ndate, $lambda, $t_SEC, $t_znameni;

  default_values();

  $checked = " checked";
  $t_znameni_check[$t_znameni] = $checked;
  if ($t_SEC == 1) $t_SEC_check = $checked;

# output HTML
  echo <<<EOF
$header
$menu

<h2>$__[3]</h2>

<form action="$cgi_file" method="get">

<p>$__[8]
<input type="text" size="10" name="phi" value="$phi">

<p><small>$__[10]
<a href="http://www.heavens-above.com"><tt>http://www.heavens-above.com</tt></a></small>

<p>$__[11] <small>[cm]</small>
<input type="text" size="5" name="a" value="$a">

<p>$__[12] <small>[HH:MM:SS]</small>
<input type="text" size="10" name="dt" value="$dt">

<p>$__[13] <small>[HH:MM:SS]</small>
<input type="text" size="10" name="de" value="$de">

<p>$__[14] <small>[cm]</small>
<input type="text" size="5" name="w" value="$w">

<p>$__[15] <small>[cm]</small>
<input type="text" size="5" name="h" value="$h">

<p>$__[16] <small>[HH:MM:SS]</small>
<input type="text" size="10" name="dd" value="$dd">

<p>$__[17]
<input type="text" size="3" name="ndate" value="$ndate">

<p>$__[9]</small>
<input type="text" size="10" name="lambda" value="$lambda">

<p>$__[33]</small>
<input type="checkbox" name="t_SEC" value="1"$t_SEC_check>

<p>$__[18]:
<input type="radio" name="t_znameni" value="0"$t_znameni_check[0]>
$__[19]
<input type="radio" name="t_znameni" value="1"$t_znameni_check[1]>
$__[20]
<input type="radio" name="t_znameni" value="2"$t_znameni_check[2]>
$__[21]

<p><input type="submit" name="submit" value="$__[22]">
<input type="submit" name="ulozit" value="$__[23]">
<input type="reset" value="$__[24]">
<a href="$cgi_file?lang=$lang">$__[25]</a>

<input type="hidden" name="lang" value="$lang" >

<p><small>$__[26]</small>

</form>
$footer
EOF;

 return 0;
}

########################################################################

function download() {
  global $header, $footer, $menu, $cgi_file, $__;

  $in = shell_exec("ls -lLh download/sha-*");
  $l = explode("\n", $in);
  $files = "";
  $tmp = 41;
  for ($i = 0; $i < sizeof($l); $i++)
    $files .= substr($l[$i], 0, $tmp) . "<a href=\"" . substr($l[$i], $tmp) . "\">" . substr($l[$i], $tmp) . "</a>\n";
  $files = substr($files, 0, strlen($files)-1);

  echo <<<EOF
$header
$menu

<h2>$__[4]</h2>

<p>$__[27]:

<pre>$files</pre>

$footer
EOF;

}

########################################################################

function sha() {
  global $header, $footer, $menu, $cgi_file, $QUERY_STRING, $lang, $__;

# form vars
  global $phi, $a, $dt, $de, $w, $h, $dd, $ndate, $lambda, $t_SEC, $t_znameni;

# data files
  $data_file = array(
    "sha.in",
    "sha.out",
    "hodin.dat",
    "datum.dat",
    "datum_prumet.dat",
    "elipsa.dat",
    "lambert.dat",
    "korekce.dat",
    "sha.png",
    "sha.pdf",
    "sha2.png",
    "deska.png",
    "deska.pdf"
  );

  default_values();

  $rnd = rand();
  shell_exec("mkdir tmp/$rnd");

  $fd = fopen("tmp/$rnd/sha.in", "w");
  $out = <<<EOF
$phi
$a
$dt
$de
$w
$h
$dd
$ndate
$lambda
$t_SEC
$t_znameni
EOF;
  fwrite($fd, $out);
  fclose($fd);

  shell_exec("./sha.sh tmp/$rnd");

  $data = "";
  for ($i = 0; $i < sizeof($data_file); $i++)
    if (strlen($data_file[$i]) > 0) {
      $tmp = $__[100+$i];
      $data .= <<<EOF
<tr>
<td valign="top"><a href="tmp/$rnd/$data_file[$i]"><code>$data_file[$i]</code></a></td>
<td width="10"></td>
<td>$tmp</td>
<tr>
EOF;
    } else
      $data .= "<tr><td colspan=\"2\"></td></tr>";

  $tmp = preg_replace("/" . $__[22] . "/", "", $QUERY_STRING);

  if ($lang==1) $str = "gb"; else $str = "cz";

  echo <<<EOF
$header
$menu

<p>[ <a href="$cgi_file?$tmp">$__[28]</a>
| <a href="$cgi_file?lang=$lang">$__[29]</a> ]

<p><table>
<tr>
<td><img src="tmp/$rnd/sha.png"></td>
</tr>
<tr>
<td valign="top"><img src="tmp/$rnd/sha2.png"></td>
</tr>
<tr>
<td><img src="tmp/$rnd/deska.png"></td>
</tr>
</table>

<p><table cellpadding="0" cellspacing=0 border=0>
<tr>
<td valign="top">$__[31]:&nbsp;</td>
<td valign="top"><img src="legenda_$str.png"></td>
</tr>
</table>

<p>$__[32]:

<p><table border="0" cellpadding="2" cellspacing="0">
$data
</table>

$footer
EOF;

 return 0;

}

########################################################################

function print_help() {
  global $header, $footer, $menu, $cgi_file, $lang, $__;

  if ($lang==1)
    $tmp = "gb";
  else
    $tmp = "cz";

  $file = "README.$tmp";
  $fd = fopen($file, "r");
  $readme = fread($fd, filesize($file));
  fclose($fd);

  $readme = preg_replace("/(http:\/\/[a-zA-Z0-9\.\/\~_\-]*)/","<a href=\"\\1\">\\1</a>", $readme);
  $readme = preg_replace("/(doc\/[a-z_]*\.[a-z]*)/","<a href=\"\\1\">\\1</a>", $readme);

  echo <<<EOF
$header
$menu

<h2>$__[5]</h2>

<pre>
$readme</pre>

$footer
EOF;

}

########################################################################

# Convert "HH:MM:SS" string to decimal hours.

function hmsh($s) {

  $l = preg_split("/:/", $s);
  $h = abs($l[0])+0.;
  if (sizeof($l) >= 3) {
    $h += $l[1]/60. + $l[1]/3600.;
  } else if (sizeof($l) == 2) {
    $h += $l[1]/60.;
  }
  if (!(strstr($l[0], "-") === false))
    $h = -$h;

  return $h;
}

########################################################################

# Signum of x.

function sgn($x) {

  if ($x > 0.)
    return 1;
  else if ($x < 0.)
    return -1;
  else
    return 0;
}

########################################################################

?>
